define([
    'modules/page/popup/external-nav-popup-view',
    'modules/help/help-popup-view',
], function(ExternalNavigationWarningPopup, HelpPopupView) {
    'use strict';

    describe('Help Popup', function() {
        var view;
        var $view;

        beforeEach(function() {
            spyOn(ExternalNavigationWarningPopup.prototype, 'openPopup');

            view = new HelpPopupView({elAfterClose: '.element-for-focus'});

            $('body').append('<a class="element-for-focus" href="#"></a>');
            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('h2.ui-title').text()).toEqual('Help');
        });

        it('has the required help desk paragraphs', function () {
            expect($view.find('.ui-content p:first-of-type').text())
                .toEqual('Help Desk (toll free): (877) 470-5947 Weekdays 7 a.m. - 7 p.m. (CT)');
            expect($view.find('.ui-content p:nth-of-type(2)').text())
                .toEqual('If you need assistance with the VA Appointments App, dial 1-877-470-5947 to speak with a Help Desk Representative. The Help Desk is open Monday - Friday from 7 a.m. to 7 p.m. CST. For TTY assistance, dial 711. If you have questions about your DS Logon account, visit mobile.DOMAIN.EX/dslogon or dial 1-800-983-0937 for assistance. Mobile App Training: Please visit mobile.DOMAIN.EX/appstore, and search for the VA Appointment App to access training materials.');
        });

        it('has the required emergency paragraphs', function () {
            expect($view.find('.ui-content p:nth-of-type(3)').text())
                .toEqual('Emergencies');
            expect($view.find('.ui-content p:nth-of-type(4)').text())
                .toEqual('If you feel that your information may have been compromised, contact your local VA facility to obtain the contact information for your Privacy Officer. To identify your local VA facility, visit View VA Facilities, or by copying and pasting the following link into your browser: https://www.DOMAIN.EX/directory/guide/division.asp?dnum=1. Note that you should never use this app in an emergency situation. If you encounter an emergency, call your local medical center or dial 911. Veterans Crisis Line: 1-800-273-8255 Press 1.');
            expect($view.find('.ui-content p:nth-of-type(4) a').attr('href'))
                .toEqual('https://www.DOMAIN.EX/directory/guide/division.asp?dnum=1');
        });

        it('has a paragraph about and link to the user guide', function () {
            expect($view.find('.ui-content p:nth-of-type(5)').text())
                .toEqual('User Guide');
            expect($view.find('.ui-content p:nth-of-type(5) a').attr('href'))
                .toEqual('app/modules/user-guide/Veteran_Appointment_Request_UG.pdf');
        });

        it('shows a warning popup for external links in the notification text body', function() {
            view.$el.find('.external-link').click();
            expect(ExternalNavigationWarningPopup.prototype.openPopup).toHaveBeenCalled();
        });

        it('has an OK button', function() {
            var loginBtn = $view.find('#help-ok-btn');
            expect(loginBtn.text()).toEqual('OK');
        });
    });
});
TTTT